//
//  Hut.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

import SpriteKit
import SPCScene
import Canvas
import SwansQuest

public class Hut : Scene, SceneAnimating {
    static let background = #imageLiteral(resourceName: "WizardHut_1024.png")
    static let ground = -290.0
    
    var hero : Hero
    var lizard : Lizard
    
    var bg: Graphic
    
    public enum HeroContents {
        case nothing, scroll, scrollChest
        
        var loadout: Hero.Loadout {
            switch self {
            case .nothing: return .nothing
            case .scroll: return .scroll
            case .scrollChest: return .scrollChest
            }
        }
    }
    
    public init(with: HeroContents = .nothing) {
        hero = Hero()
        hero.holding = with.loadout
        lizard = Lizard()
        bg = Graphic(image: Image(with: Hut.background), name: "Lizard's Hut")
        bg.enableAccessibility(label: "", select: true)
        
        super.init(size: Scene.sceneSize)
        
        self.place(bg, at: Point.center)
        self.place(hero, at: Point(x: 130.0, y: Hut.ground))
        self.place(lizard, at: Point(x: -212.0, y: Hut.ground))
    }

    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // MARK: - SceneAnimating
    
    public var sceneTransition: SKTransition?
    public var animationDelegate: SceneAnimatingDelegate?
    public var loadingDescription: String? {
        didSet {
            enableAccessibility(label: loadingDescription!)
        }
    }
    
    public func sceneIsPresented() {
        hero.turn()
        lizard.turn()
        lizard.idle()
        
        animationDelegate?.sceneDidLoad(self)
        
        hero.walk(distance: -230.0) {
            self.hero.removeAllActions()
            self.animationDelegate?.sceneDidFinishAnimations(self)
        }
    }
    
    public func sceneWillDismiss() {
        
    }
}
